<?php
// Load simple configuration (no .env needed)
require_once 'config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ReviewPR - Professional Review Management Services</title>
    <meta name="description" content="Get authentic reviews for your business across 70+ platforms. Professional review management services starting from $1.10. Boost your online reputation today!">
    
    <!-- Performance Optimization -->
    <link rel="preconnect" href="https://cdn.jsdelivr.net" crossorigin>
    <link rel="preconnect" href="https://cdnjs.cloudflare.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    
    <!-- DNS Prefetch for better performance -->
    <link rel="dns-prefetch" href="//cdn.jsdelivr.net">
    <link rel="dns-prefetch" href="//cdnjs.cloudflare.com">
    <link rel="dns-prefetch" href="//fonts.googleapis.com">
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    
    <!-- Critical CSS - Load immediately -->
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="assets/css/optimized.min.css" rel="stylesheet">
    
    <!-- Non-critical CSS - Load asynchronously -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" as="style" onload="this.onload=null;this.rel='stylesheet'">
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" as="style" onload="this.onload=null;this.rel='stylesheet'">
    
    <!-- Fallback for browsers that don't support preload -->
    <noscript>
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    </noscript>
    
    <style>
        /* Critical CSS - Above the fold styles */
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif; line-height: 1.6; }
        
        .gradient-bg { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .glass-effect { backdrop-filter: blur(20px); background: rgba(255, 255, 255, 0.1); border: 1px solid rgba(255, 255, 255, 0.2); }
        .text-gradient { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; }
        
        /* Navigation */
        nav { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; padding: 1rem 0; transition: all 0.3s ease; }
        
        /* Hero Section - Critical */
        .hero { min-height: 100vh; display: flex; align-items: center; padding: 6rem 0 4rem; position: relative; }
        .hero h1 { font-size: clamp(2.5rem, 5vw, 4rem); font-weight: 800; line-height: 1.1; margin-bottom: 1.5rem; color: white; }
        .hero p { font-size: 1.25rem; margin-bottom: 2rem; opacity: 0.9; color: #e0e7ff; }
        
        /* Buttons */
        .btn-primary { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 0.75rem 2rem; border-radius: 0.5rem; text-decoration: none; font-weight: 600; display: inline-flex; align-items: center; transition: all 0.3s ease; }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4); }
        
        /* Loading animation */
        @keyframes spin { from { transform: rotate(0deg); } to { transform: rotate(360deg); } }
        .animate-spin { animation: spin 1s linear infinite; }
        
        /* Float animation */
        @keyframes float { 0%, 100% { transform: translateY(0px); } 50% { transform: translateY(-20px); } }
        .animate-float { animation: float 6s ease-in-out infinite; }
        
        /* Hover effects */
        .hover-lift { transition: transform 0.3s ease, box-shadow 0.3s ease; }
        .hover-lift:hover { transform: translateY(-5px); box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1); }
        
        /* Stats */
        .stats-counter { font-size: 3rem; font-weight: 800; color: #fbbf24; }
        
        /* Feature icons */
        .feature-icon { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Navigation -->
    <nav class="fixed w-full z-50 glass-effect">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <div class="flex items-center">
                    <div class="text-2xl font-bold text-gradient">
                        <i class="fas fa-star mr-2"></i>ReviewPR
                    </div>
                </div>
                
                <div class="hidden md:block">
                    <div class="ml-10 flex items-baseline space-x-8">
                        <a href="#home" class="text-white hover:text-blue-200 px-3 py-2 text-sm font-medium transition-colors">Home</a>
                        <a href="#services" class="text-white hover:text-blue-200 px-3 py-2 text-sm font-medium transition-colors">Services</a>
                        <a href="#pricing" class="text-white hover:text-blue-200 px-3 py-2 text-sm font-medium transition-colors">Pricing</a>
                        <a href="#about" class="text-white hover:text-blue-200 px-3 py-2 text-sm font-medium transition-colors">About</a>
                        <a href="#contact" class="text-white hover:text-blue-200 px-3 py-2 text-sm font-medium transition-colors">Contact</a>
                    </div>
                </div>
                
                <div class="md:hidden">
                    <button class="text-white hover:text-blue-200">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section id="home" class="gradient-bg min-h-screen flex items-center">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
            <div class="grid lg:grid-cols-2 gap-12 items-center">
                <div class="text-white">
                    <h1 class="text-5xl lg:text-6xl font-bold mb-6 leading-tight">
                        Boost Your Online
                        <span class="block text-yellow-300">Reputation</span>
                    </h1>
                    <p class="text-xl mb-8 text-blue-100 leading-relaxed">
                        Get authentic reviews across 70+ platforms including Trustpilot, Google, G2, and more. 
                        Professional review management services starting from just $1.10.
                    </p>
                    
                    <div class="flex flex-col sm:flex-row gap-4 mb-12">
                        <button class="btn-primary text-white px-8 py-4 rounded-lg font-semibold text-lg">
                            <i class="fas fa-rocket mr-2"></i>Get Started Now
                        </button>
                        <button class="border-2 border-white text-white px-8 py-4 rounded-lg font-semibold text-lg hover:bg-white hover:text-blue-600 transition-all">
                            <i class="fas fa-play mr-2"></i>Watch Demo
                        </button>
                    </div>
                    
                    <!-- Trust Indicators -->
                    <div class="flex items-center space-x-8">
                        <div class="text-center">
                            <div class="stats-counter">2,847</div>
                            <div class="text-blue-200">Happy Clients</div>
                        </div>
                        <div class="text-center">
                            <div class="stats-counter">70+</div>
                            <div class="text-blue-200">Platforms</div>
                        </div>
                        <div class="text-center">
                            <div class="stats-counter">99.9%</div>
                            <div class="text-blue-200">Success Rate</div>
                        </div>
                    </div>
                </div>
                
                <div class="relative">
                    <div class="animate-float">
                        <div class="bg-white rounded-2xl p-8 shadow-2xl">
                            <div class="text-center mb-6">
                                <h3 class="text-2xl font-bold text-gray-800 mb-2">Quick Order</h3>
                                <p class="text-gray-600">Start boosting your reputation now</p>
                            </div>
                            
                            <form id="quick-order-form" class="space-y-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Select Service</label>
                                    <select id="quick-platform" name="platform" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                        <option value="">Choose a service...</option>
                                        <option value="temp1" data-price="2.10">Trustpilot Reviews - $2.10</option>
                                        <option value="temp2" data-price="3.50">Google Reviews - $3.50</option>
                                        <option value="temp3" data-price="21.99">G2 Reviews - $21.99</option>
                                        <option value="temp4" data-price="1.10">Facebook Reviews - $1.10</option>
                                        <option value="temp5" data-price="9.99">Yelp Reviews - $9.99</option>
                                    </select>
                                </div>
                                
                                <div id="price-display" class="text-center py-4 bg-gray-50 rounded-lg" style="display: none;">
                                    <div class="text-2xl font-bold text-blue-600" id="selected-price">$0.00</div>
                                    <div class="text-sm text-gray-600" id="selected-description">Select a service to see price</div>
                                </div>
                                
                                <button type="submit" class="w-full btn-primary text-white py-3 rounded-lg font-semibold" id="quick-order-btn" disabled>
                                    <i class="fas fa-shopping-cart mr-2"></i>Select Service First
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section id="services" class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-900 mb-4">Our Services</h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                    Professional review management across all major platforms to boost your online reputation and credibility.
                </p>
            </div>
            
            <div id="featured-services" class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Featured services - Static fallback with real prices -->
                <div class="bg-white rounded-xl shadow-lg hover-lift p-8 border border-gray-100">
                    <div class="text-4xl feature-icon mb-4">
                        <i class="fab fa-trustpilot"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3">Trustpilot Reviews</h3>
                    <p class="text-gray-600 mb-4">5 Star TrustPilot Reviews - Genuine and Top Quality. Build trust and credibility for your business.</p>
                    <div class="text-2xl font-bold text-gradient mb-4">$2.10</div>
                    <button onclick="orderService('trustpilot', 2.10)" class="w-full bg-blue-50 text-blue-600 py-2 rounded-lg font-semibold hover:bg-blue-100 transition-colors">
                        Order Now
                    </button>
                </div>
                
                <div class="bg-white rounded-xl shadow-lg hover-lift p-8 border border-gray-100">
                    <div class="text-4xl feature-icon mb-4">
                        <i class="fab fa-google"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3">Google Reviews</h3>
                    <p class="text-gray-600 mb-4">The Great Place to Buy Google Positive Reviews. Boost your local SEO and visibility.</p>
                    <div class="text-2xl font-bold text-gradient mb-4">$3.50</div>
                    <button onclick="orderService('google', 3.50)" class="w-full bg-blue-50 text-blue-600 py-2 rounded-lg font-semibold hover:bg-blue-100 transition-colors">
                        Order Now
                    </button>
                </div>
                
                <div class="bg-white rounded-xl shadow-lg hover-lift p-8 border border-gray-100">
                    <div class="text-4xl feature-icon mb-4">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3">G2 Reviews</h3>
                    <p class="text-gray-600 mb-4">High-quality and Authentic User Post. Establish authority in the B2B space with professional reviews.</p>
                    <div class="text-2xl font-bold text-gradient mb-4">$21.99</div>
                    <button onclick="orderService('g2', 21.99)" class="w-full bg-blue-50 text-blue-600 py-2 rounded-lg font-semibold hover:bg-blue-100 transition-colors">
                        Order Now
                    </button>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-900 mb-4">Why Choose ReviewPR?</h2>
                <p class="text-xl text-gray-600">We deliver results that matter for your business</p>
            </div>
            
            <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
                <div class="text-center">
                    <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-shield-alt text-2xl text-blue-600"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">100% Authentic</h3>
                    <p class="text-gray-600">All reviews are from real users with verified profiles</p>
                </div>
                
                <div class="text-center">
                    <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-clock text-2xl text-green-600"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Fast Delivery</h3>
                    <p class="text-gray-600">Reviews delivered within 24-72 hours guaranteed</p>
                </div>
                
                <div class="text-center">
                    <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-headset text-2xl text-purple-600"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">24/7 Support</h3>
                    <p class="text-gray-600">Round-the-clock customer support for all your needs</p>
                </div>
                
                <div class="text-center">
                    <div class="w-16 h-16 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-award text-2xl text-yellow-600"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Money Back</h3>
                    <p class="text-gray-600">30-day money-back guarantee on all services</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-900 mb-4">What Our Clients Say</h2>
                <p class="text-xl text-gray-600">Join thousands of satisfied customers who trust ReviewPR</p>
            </div>
            
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                <div class="bg-white rounded-xl shadow-lg p-8 border border-gray-100">
                    <div class="flex items-center mb-4">
                        <div class="flex text-yellow-400">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                    <p class="text-gray-600 mb-6 italic">"ReviewPR helped us increase our Trustpilot rating from 3.2 to 4.8 in just 2 months. The reviews are authentic and the service is professional."</p>
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-blue-500 rounded-full flex items-center justify-center text-white font-bold mr-4">
                            SJ
                        </div>
                        <div>
                            <h4 class="font-semibold text-gray-900">Sarah Johnson</h4>
                            <p class="text-gray-500 text-sm">CEO, TechStart Inc.</p>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-xl shadow-lg p-8 border border-gray-100">
                    <div class="flex items-center mb-4">
                        <div class="flex text-yellow-400">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                    <p class="text-gray-600 mb-6 italic">"Excellent service! Got 25 Google reviews delivered within 48 hours. Our local SEO improved dramatically. Highly recommended!"</p>
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-green-500 rounded-full flex items-center justify-center text-white font-bold mr-4">
                            MR
                        </div>
                        <div>
                            <h4 class="font-semibold text-gray-900">Michael Rodriguez</h4>
                            <p class="text-gray-500 text-sm">Owner, Local Restaurant</p>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded-xl shadow-lg p-8 border border-gray-100">
                    <div class="flex items-center mb-4">
                        <div class="flex text-yellow-400">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                    <p class="text-gray-600 mb-6 italic">"The G2 reviews we received helped us close 3 major enterprise deals. ROI was incredible. Will definitely use again!"</p>
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-purple-500 rounded-full flex items-center justify-center text-white font-bold mr-4">
                            AL
                        </div>
                        <div>
                            <h4 class="font-semibold text-gray-900">Amanda Lee</h4>
                            <p class="text-gray-500 text-sm">VP Marketing, SaaS Company</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="py-20 gradient-bg">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center text-white">
                <h2 class="text-4xl font-bold mb-4">Trusted by Businesses Worldwide</h2>
                <p class="text-xl text-blue-100 mb-12">Our numbers speak for themselves</p>
                
                <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
                    <div class="text-center">
                        <div class="text-5xl font-bold text-yellow-300 mb-2">2,847+</div>
                        <div class="text-blue-100">Happy Clients</div>
                    </div>
                    <div class="text-center">
                        <div class="text-5xl font-bold text-yellow-300 mb-2">70+</div>
                        <div class="text-blue-100">Review Platforms</div>
                    </div>
                    <div class="text-center">
                        <div class="text-5xl font-bold text-yellow-300 mb-2">99.9%</div>
                        <div class="text-blue-100">Success Rate</div>
                    </div>
                    <div class="text-center">
                        <div class="text-5xl font-bold text-yellow-300 mb-2">24/7</div>
                        <div class="text-blue-100">Support Available</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Products Section -->
    <section id="pricing" class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-900 mb-4">Our Products</h2>
                <p class="text-xl text-gray-600">Choose from our wide range of review services</p>
            </div>
            
            <div class="products-grid grid md:grid-cols-2 lg:grid-cols-3 gap-8" id="products-container">
                <?php
                require_once 'config.php';
                try {
                    // Use secure connection from config
                    $conn = getSecureConnection();

                    // Fetch all products
                    $result = $conn->query('SELECT * FROM products ORDER BY position ASC, id ASC');
                    if (!$result) {
                        throw new Exception($conn->error);
                    }
                    $products = $result->fetch_all(MYSQLI_ASSOC);

                    if (count($products) > 0) {
                        foreach ($products as $product) {
                            // Use placeholder images since we don't have actual image files
                            $image_url = 'data:image/svg+xml;charset=UTF-8,%3Csvg width=\"300\" height=\"200\" viewBox=\"0 0 300 200\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"%3E%3Crect width=\"300\" height=\"200\" fill=\"%23F3F4F6\"/%3E%3Cpath d=\"M150 125L175 100H175L150 75H125L175 50H175L150 25H125L75 50L175 100L150 125Z\" fill=\"%23D1D5DB\"/%3E%3C/svg%3E';
                            $in_stock = $product['stock'] > 0 ? 'In Stock' : 'Out of Stock';
                            $stock_class = $product['stock'] > 0 ? 'text-green-600 bg-green-100' : 'text-red-600 bg-red-100';

                            echo "
                <div class=\"bg-white rounded-xl shadow-lg hover-lift p-6 border border-gray-100 product-card\">
                    <div class=\"mb-4\">
                        <img src=\"{$image_url}\" alt=\"{$product['name']}\" class=\"w-full h-48 object-cover rounded-lg\">
                    </div>
                    <h3 class=\"text-xl font-bold text-gray-900 mb-2\">{$product['name']}</h3>
                    <div class=\"product-description mb-4\">
                        <p class=\"text-gray-600 description-short\" style=\"display: block;\">". (strlen($product['description']) > 100 ? substr($product['description'], 0, 100) . '...' : $product['description']) ."</p>
                        <p class=\"text-gray-600 description-full\" style=\"display: none;\">{$product['description']}</p>
                    </div>
                    <div class=\"flex items-center justify-between mb-4\">
                        <span class=\"text-2xl font-bold text-blue-600\">\${$product['price']}</span>
                        <div class=\"flex items-center gap-2\">
                            <span class=\"text-sm {$stock_class} px-2 py-1 rounded\">{$in_stock}</span>
                            ". (strlen($product['description']) > 100 ? "<button class=\"read-more-btn inline-flex items-center gap-1 text-blue-600 hover:text-blue-800 text-xs font-medium px-2 py-1 rounded border border-blue-200 hover:border-blue-300 bg-blue-50 hover:bg-blue-100 transition-all duration-200\" onclick=\"toggleDescription(this)\">
                                <i class=\"fas fa-chevron-down text-xs transition-transform duration-200\"></i>
                                <span>Read More</span>
                            </button>" : "") ."
                        </div>
                    </div>
                    <button onclick=\"orderService('{$product['name']}', {$product['price']})\" class=\"w-full bg-blue-600 text-white py-2 px-4 rounded-lg hover:bg-blue-700 transition-colors\">
                        <i class=\"fas fa-shopping-cart mr-2\"></i>Order Now
                    </button>
                </div>";
                        }
                    } else {
                        echo '<p class="text-center text-gray-500 col-span-full">No products available at the moment.</p>';
                    }
                    $conn->close();
                } catch (Exception $e) {
                    echo '<p class="text-center text-red-500 col-span-full">Error loading products: ' . htmlspecialchars($e->getMessage()) . '</p>';
                }
                ?>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-900 text-white py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid md:grid-cols-4 gap-8">
                <div>
                    <div class="text-2xl font-bold text-gradient mb-4">
                        <i class="fas fa-star mr-2"></i>ReviewPR
                    </div>
                    <p class="text-gray-400 mb-4">Professional review management services to boost your online reputation.</p>
                    <div class="flex space-x-4">
                        <a href="#" class="text-gray-400 hover:text-white"><i class="fab fa-facebook"></i></a>
                        <a href="#" class="text-gray-400 hover:text-white"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="text-gray-400 hover:text-white"><i class="fab fa-linkedin"></i></a>
                        <a href="#" class="text-gray-400 hover:text-white"><i class="fab fa-instagram"></i></a>
                    </div>
                </div>
                
                <div>
                    <h3 class="text-lg font-semibold mb-4">Services</h3>
                    <ul class="space-y-2 text-gray-400">
                        <li><a href="#" class="hover:text-white">Trustpilot Reviews</a></li>
                        <li><a href="#" class="hover:text-white">Google Reviews</a></li>
                        <li><a href="#" class="hover:text-white">G2 Reviews</a></li>
                        <li><a href="#" class="hover:text-white">Capterra Reviews</a></li>
                    </ul>
                </div>
                
                <div>
                    <h3 class="text-lg font-semibold mb-4">Company</h3>
                    <ul class="space-y-2 text-gray-400">
                        <li><a href="#" class="hover:text-white">About Us</a></li>
                        <li><a href="#" class="hover:text-white">Pricing</a></li>
                        <li><a href="#" class="hover:text-white">Contact</a></li>
                        <li><a href="#" class="hover:text-white">FAQ</a></li>
                    </ul>
                </div>
                
                <div>
                    <h3 class="text-lg font-semibold mb-4">Contact</h3>
                    <ul class="space-y-2 text-gray-400">
                        <li><i class="fas fa-envelope mr-2"></i>support@reviewpr.com</li>
                        <li><i class="fas fa-phone mr-2"></i>+1 (555) 123-4567</li>
                        <li><i class="fas fa-clock mr-2"></i>24/7 Support</li>
                    </ul>
                </div>
            </div>
            
            <div class="border-t border-gray-800 mt-8 pt-8 text-center text-gray-400">
                <p>&copy; 2025 ReviewPR. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="assets/js/modern-script.js" defer></script>
    
    <!-- Service Worker Disabled for Development -->
    <script>
        // Completely disable Service Worker for local development
        console.log('SW: Service Worker disabled for development');
        
        // Clear any existing Service Worker
        if ('serviceWorker' in navigator) {
            navigator.serviceWorker.getRegistrations().then(function(registrations) {
                for(let registration of registrations) {
                    registration.unregister();
                    console.log('SW: Unregistered existing service worker');
                }
            });
        }
        
        // Toggle product description
        function toggleDescription(button) {
            const card = button.closest('.product-card');
            const shortDesc = card.querySelector('.description-short');
            const fullDesc = card.querySelector('.description-full');
            const icon = button.querySelector('i');

            if (shortDesc.style.display === 'block') {
                shortDesc.style.display = 'none';
                fullDesc.style.display = 'block';
                button.querySelector('span').textContent = 'Show Less';
                icon.style.transform = 'rotate(180deg)';
                button.classList.remove('bg-blue-50', 'border-blue-200');
                button.classList.add('bg-gray-50', 'border-gray-300');
            } else {
                shortDesc.style.display = 'block';
                fullDesc.style.display = 'none';
                button.querySelector('span').textContent = 'Read More';
                icon.style.transform = 'rotate(0deg)';
                button.classList.remove('bg-gray-50', 'border-gray-300');
                button.classList.add('bg-blue-50', 'border-blue-200');
            }
        }
        
        // Order service function
        function orderService(serviceType, price) {
            // Show notification
            showNotification(`Redirecting to checkout for ${serviceType} reviews - $${price.toFixed(2)}`, 'info');
            
            // Redirect to checkout with service info
            setTimeout(() => {
                window.location.href = `simple-checkout.php?service=${serviceType}&price=${price}`;
            }, 1000);
        }
        function showNotification(message, type = 'info') {
            const notification = document.createElement('div');
            notification.className = `fixed top-4 right-4 z-50 p-4 rounded-lg shadow-lg max-w-sm transform transition-all duration-300`;
            
            const bgColor = {
                success: 'bg-green-500',
                error: 'bg-red-500',
                info: 'bg-blue-500',
                warning: 'bg-yellow-500'
            };
            
            notification.className += ` ${bgColor[type] || bgColor.info} text-white`;
            notification.innerHTML = `
                <div class="flex items-center">
                    <span class="mr-2">${type === 'success' ? '✅' : type === 'error' ? '❌' : 'ℹ️'}</span>
                    <span>${message}</span>
                </div>
            `;
            
            document.body.appendChild(notification);
            
            // Animate in
            setTimeout(() => {
                notification.style.transform = 'translateX(0)';
            }, 100);
            
            // Remove after 3 seconds
            setTimeout(() => {
                notification.style.transform = 'translateX(100%)';
                setTimeout(() => {
                    document.body.removeChild(notification);
                }, 300);
            }, 3000);
        }

        // Performance monitoring
        window.addEventListener('load', () => {
            // Log performance metrics
            const perfData = performance.getEntriesByType('navigation')[0];
            if (perfData) {
                console.log('Performance Metrics:', {
                    'DNS Lookup': Math.round(perfData.domainLookupEnd - perfData.domainLookupStart),
                    'TCP Connection': Math.round(perfData.connectEnd - perfData.connectStart),
                    'Request': Math.round(perfData.responseStart - perfData.requestStart),
                    'Response': Math.round(perfData.responseEnd - perfData.responseStart),
                    'DOM Processing': Math.round(perfData.domContentLoadedEventEnd - perfData.responseEnd),
                    'Total Load Time': Math.round(perfData.loadEventEnd - perfData.navigationStart)
                });
            }
        });
    </script>
</body>
</html>
